&lt;?php

require_once '../config/db.php';

header('Content-Type: application/json');

header('Access-Control-Allow-Origin: *'); // Permite requisições do frontend

header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');

header('Access-Control-Allow-Headers: Content-Type, Authorization');

if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
  exit(0);
}

$path = $_SERVER['PATH_INFO'] ?? '/';

$segments = explode('/', ltrim($path, '/'));

$endpoint = $segments[0] ?? '';

$method = $_SERVER['REQUEST_METHOD'];

$data = json_decode(file_get_contents('php://input'), true) ?? [];

switch ($endpoint) {
  case 'login':
  case 'register':
    require 'auth.php';
    break;
  case 'point':
    require 'point.php';
    break;
  case 'report':
    require 'report.php';
    break;
  case 'user':
    require 'user.php';
    break;
  default:
    http_response_code(404);
    echo json_encode(['message' => 'Endpoint não encontrado']);
}

?&gt;