&lt;?php

require_once 'utils.php';

$user = verifyToken();

if ($user['role'] !== 'admin') {
  http_response_code(403);
  echo json_encode(['message' => 'Acesso negado - apenas admins']);
  exit;
}

if ($method === 'GET') {
  $userId = $_GET['user_id'] ?? null;
  $start = $_GET['start'] ?? date('Y-m-01');
  $end = $_GET['end'] ?? date('Y-m-t', strtotime($start));
  $query = "SELECT u.username, p.timestamp, p.type FROM points p JOIN users u ON p.user_id = u.id WHERE p.timestamp BETWEEN ? AND ?";
  $params = [$start . ' 00:00:00', $end . ' 23:59:59'];
  if ($userId) {
    $query .= " AND p.user_id = ?";
    $params[] = $userId;
  }
  $query .= " ORDER BY u.username, p.timestamp";
  $pdo = getDB();
  $stmt = $pdo->prepare($query);
  $stmt->execute($params);
  $reports = $stmt->fetchAll(PDO::FETCH_ASSOC);
  echo json_encode($reports);
}

?&gt;