&lt;?php

require_once 'utils.php';

$user = verifyToken();

if ($user['role'] !== 'admin') {
  http_response_code(403);
  echo json_encode(['message' => 'Acesso negado - apenas admins']);
  exit;
}

if ($method === 'GET') {
  $pdo = getDB();
  $stmt = $pdo->prepare("SELECT id, username, role FROM users");
  $stmt->execute();
  $users = $stmt->fetchAll(PDO::FETCH_ASSOC);
  echo json_encode($users);
} elseif ($method === 'PUT') {
  $id = $data['id'] ?? 0;
  $role = $data['role'] ?? 'user';
  $pdo = getDB();
  $stmt = $pdo->prepare("UPDATE users SET role = ? WHERE id = ?");
  $stmt->execute([$role, $id]);
  echo json_encode(['message' => 'Usuário atualizado com sucesso']);
} elseif ($method === 'DELETE') {
  $id = $data['id'] ?? 0;
  $pdo = getDB();
  $stmt = $pdo->prepare("DELETE FROM users WHERE id = ?");
  $stmt->execute([$id]);
  echo json_encode(['message' => 'Usuário deletado com sucesso']);
}

?&gt;