&lt;?php
<?php

// Load centralized config
$cfg = require __DIR__ . '/config.php';

function getDB() {
  global $cfg;
  $host = $cfg['db']['host'] ?? '127.0.0.1';
  $dbname = $cfg['db']['name'] ?? 'time_tracking';
  $user = $cfg['db']['user'] ?? 'root';
  $pass = $cfg['db']['pass'] ?? '';
  try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    $pdo->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
    return $pdo;
  } catch (PDOException $e) {
    // In production don't echo DB errors - log instead
    error_log('DB connection failed: ' . $e->getMessage());
    http_response_code(500);
    echo json_encode(['message' => 'Database connection error']);
    exit;
  }
}

?>